#ifndef QUEUE_H
#define QUEUE_H

#include <stdexcept>

template<typename Type>
class Queue {
	private:
		class QueueItem {
			public:
				QueueItem(Type item);
				QueueItem(Type item, QueueItem* next);
				Type item;
				QueueItem* next;
		};
		QueueItem* head;
		QueueItem* tail;
	public:
		Queue();
		~Queue();
		void put(Type item);
		void putFront(Type item);
		bool isEmpty();
		Type get();
		Type peek();
		void removeAll();
};

//------------------------------------------------------------------------------

template<typename Type>
Queue<Type>::QueueItem::QueueItem(Type item){
	this->item = item;
	next = nullptr;
}

template<typename Type>
Queue<Type>::QueueItem::QueueItem(Type item, QueueItem* next){
	this->item = item;
	this->next = next;
}

template<typename Type>
Queue<Type>::Queue(){
	head = nullptr;
	tail = nullptr;
}

template<typename Type>
Queue<Type>::~Queue(){
    removeAll();
}

template<typename Type>
void Queue<Type>::put(Type item){
	if(tail == nullptr){
		tail = new QueueItem(item);
		head = tail;
	} else {
		tail->next = new QueueItem(item);
		tail = tail->next;
	}
}

template<typename Type>
void Queue<Type>::putFront(Type item){
    head = new QueueItem(item, head);
    if(tail == nullptr)
        tail = head;
	/*if(tail == nullptr){
		tail = new QueueItem(item);
		head = tail;
	} else {
		tail->next = new QueueItem(item);
		tail = tail->next;
	}*/
}

template<typename Type>
bool Queue<Type>::isEmpty(){
	return (head == nullptr);
}

template<typename Type>
Type Queue<Type>::get(){
	if(head == nullptr)
		throw std::out_of_range("Queue is empty.");
	Type item = head->item;
	QueueItem* next = head->next;
	delete head;
	head = next;
	if(head == nullptr)
        tail = nullptr;
	return item;
}

template<typename Type>
Type Queue<Type>::peek(){
    if(head == nullptr)
		throw std::out_of_range("Queue is empty.");
    return head->item;
}

template<typename Type>
void Queue<Type>::removeAll(){
    while(!isEmpty())
        get();
}

#endif // QUEUE_H
