#ifndef BINARYTREE_H
#define BINARYTREE_H

#include "queue.h"
#include <stdexcept>
#include <cmath>

class BinaryTree {
	private:
		class Node {
			public:
				int value;
				Node* left;
				Node* right;

				Node();
				Node(int value);
		};
		Node* root;
		Node* &nodeSearch(int value, Node** node);
	public:
	    class NodeRef {
            private:
                Node* node;
            public:
                NodeRef();
                NodeRef(Node* node);
                bool isValid();
                int getValue();
                NodeRef getLeft();
                NodeRef getRight();
                void goRight();
                void goLeft();
                //void* getNodePtr();
	    };
		struct Statistics {
			unsigned int height;
			unsigned int nodeCount;
			unsigned int internalNodeCount;
			unsigned int leafNodeCount;
			unsigned int nodeWithOneChildCount;
			unsigned int nodeWithTwoChildrenCount;
			bool balanced;
			bool perfectlyBalanced;
		};
		BinaryTree();
		~BinaryTree();
		NodeRef getRoot();
		bool insertValue(int value);
		bool removeValue(int value);
		NodeRef findValue(int value);
		void removeAll();
		Statistics getStatistics();
		Statistics getStatistics(NodeRef node);
	private:
		Statistics getStatisticsRecursive(Node *nodeRef);
};

#endif
