#include "binarytree.h"

#define USE_RECURSIVE

/*    Node    */
BinaryTree::Node::Node(){
	value = 0;
	left = nullptr;
	right = nullptr;
}

BinaryTree::Node::Node(int value){
	this->value = value;
	left = nullptr;
	right = nullptr;
}

/*    NodeRef    */
BinaryTree::NodeRef::NodeRef(){
    node = nullptr;
}

BinaryTree::NodeRef::NodeRef(Node* node){
    this->node = node;
}

bool BinaryTree::NodeRef::isValid(){
    return (node != nullptr);
}

int BinaryTree::NodeRef::getValue(){
    if(node != nullptr)
        return node->value;
    throw std::runtime_error("NodeRef is invalid.");
}

BinaryTree::NodeRef BinaryTree::NodeRef::getLeft(){
    if(node != nullptr)
        return NodeRef(node->left);
    return *this;
}

BinaryTree::NodeRef BinaryTree::NodeRef::getRight(){
    if(node != nullptr)
        return NodeRef(node->right);
    return *this;
}

void BinaryTree::NodeRef::goLeft(){
    if(node != nullptr)
        node = node->left;
}

void BinaryTree::NodeRef::goRight(){
    if(node != nullptr)
        node = node->right;
}

/*void* BinaryTree::NodeRef::getNodePtr(){
	return (void*)node;
}*/

/*    BinaryTree    */
BinaryTree::BinaryTree(){
	root = nullptr;
}

BinaryTree::~BinaryTree(){
	removeAll();
}

BinaryTree::NodeRef BinaryTree::getRoot(){
    return NodeRef(root);
}

bool BinaryTree::insertValue(int value){
	Node* &node = nodeSearch(value, &root);
	if(node == nullptr){
		node = new Node(value);
		return true;
	}
	return false;
}

bool BinaryTree::removeValue(int value){
	Node* &node = nodeSearch(value, &root);
	if(node != nullptr){
		Node* replaceNode = nullptr;
		bool fromRight;
		if((fromRight = (node->right != nullptr)))
			replaceNode = node->right;
		else if(node->left != nullptr)
			replaceNode = node->left;
		if(replaceNode == nullptr){
			delete node;
			node = nullptr;
			return true;
		}
		Node* replaceNodeParent = node;
        while((fromRight? replaceNode->left : replaceNode->left) != nullptr){
			replaceNodeParent = replaceNode;
			if(fromRight)
				replaceNode = replaceNode->left;
			else
				replaceNode = replaceNode->right;
        }
        if(fromRight){
			if(replaceNodeParent == node){
				node->right = replaceNode->right;
			} else
				replaceNodeParent->left = replaceNode->right;
			node->value = replaceNode->value;
        } else {
			if(replaceNodeParent == node){
				node->left = replaceNode->left;
			} else
				replaceNodeParent->right = replaceNode->left;
			node->value = replaceNode->value;
        }
		delete replaceNode;
        return true;
	}
	return false;
}

BinaryTree::NodeRef BinaryTree::findValue(int value){
    Node* &node = nodeSearch(value, &root);
    return NodeRef(node);
}

BinaryTree::Node* &BinaryTree::nodeSearch(int value, Node** node){
	while( (*node != nullptr) && ((*node)->value != value) )
		node = &( (value < (*node)->value)? (*node)->left : (*node)->right);
	return *node;
}

void BinaryTree::removeAll(){
	Queue<Node*> queue;
	queue.put(root);
	do {
		Node* node = queue.get();
		if(node != nullptr){
			queue.put(node->left);
			queue.put(node->right);
			delete node;
		}
	} while(!queue.isEmpty());
	root = nullptr;
}

BinaryTree::Statistics BinaryTree::getStatisticsRecursive(Node *node){
	Statistics stats = {0, 0, 0, 0, 0, 0, true, true};
	if(node == nullptr)
		return stats;
	Statistics statsLeft = {0, 0, 0, 0, 0, 0, true, true};
	Statistics statsRight = {0, 0, 0, 0, 0, 0, true, true};
	bool hasLeft = node->left != nullptr;
	bool hasRight = node->right != nullptr;
	if(hasLeft)
		statsLeft = getStatisticsRecursive(node->left);
	if(hasRight)
		statsRight = getStatisticsRecursive(node->right);
	stats.balanced = (statsLeft.balanced && statsRight.balanced) && ( (statsLeft.height > statsRight.height)? statsLeft.height - statsRight.height : statsRight.height - statsLeft.height ) <= 1;
	stats.perfectlyBalanced = (statsLeft.perfectlyBalanced && statsRight.perfectlyBalanced) && ( (statsLeft.nodeCount > statsRight.nodeCount)? statsLeft.nodeCount - statsRight.nodeCount : statsRight.nodeCount - statsLeft.nodeCount ) <= 1;
	stats.nodeCount = statsLeft.nodeCount + statsRight.nodeCount + 1;
	stats.nodeWithOneChildCount = statsLeft.nodeWithOneChildCount + statsRight.nodeWithOneChildCount + ((hasLeft != hasRight)? 1 : 0);
	stats.nodeWithTwoChildrenCount = statsLeft.nodeWithTwoChildrenCount + statsRight.nodeWithTwoChildrenCount + ((hasLeft&&hasRight)? 1 : 0);
	stats.height = 1 + ((statsLeft.height > statsRight.height) ? statsLeft.height : statsRight.height);
	return stats;
}

#ifdef USE_RECURSIVE
BinaryTree::Statistics BinaryTree::getStatistics(){
	Statistics stats = {0, 0, 0, 0, 0, 0, true, true};
	if(root != nullptr){
		stats = getStatisticsRecursive(root);
		stats.internalNodeCount = stats.nodeWithOneChildCount + stats.nodeWithTwoChildrenCount;
		stats.leafNodeCount = stats.nodeCount - stats.internalNodeCount;
		if(stats.height > 0)
			stats.height--;
	}
	return stats;
}
#else
BinaryTree::Statistics BinaryTree::getStatistics(){
	Statistics stats = {0, 0, 0, 0, 0, 0, true, true};
	if(root == nullptr)
		return stats;
	bool firstLeafFound = false;
	bool firstInRow = false;
	bool firstLeafOnFirstRow = false;
	unsigned int leafHeight;
	Queue<Node*> queue;
	queue.put(root);
	queue.put(nullptr);
	Queue<int> lastRow;
	do {
		Node* node = queue.get();
		if(node == nullptr){
			stats.height++;
			if(!queue.isEmpty()){
				queue.put(nullptr);
				firstInRow = true;
			}
            continue;
		} else {
            firstInRow = false;
		}
		stats.nodeCount++;
		bool hasLeft = node->left != nullptr;
		bool hasRight = node->right != nullptr;
		if(hasLeft)
			queue.put(node->left);
		if(hasRight)
			queue.put(node->right);
		if(hasLeft && hasRight)
			stats.nodeWithTwoChildrenCount++;
		else if(hasLeft || hasRight){
			stats.nodeWithOneChildCount++;
			stats.balanced &= ( hasLeft ? (node->left->left == nullptr && node->left->right == nullptr) : (node->right->left == nullptr && node->right->right == nullptr) );
		} else {
			if(stats.balanced){
				if(firstLeafFound){
					stats.balanced &= (stats.height <= leafHeight+1);
				} else {
					leafHeight = stats.height;
					firstLeafFound = true;
					firstLeafOnFirstRow = firstInRow;
				}
			}
		}
		if(stats.balanced && firstLeafFound && stats.height == leafHeight){
			lastRow.put(hasLeft ? 1 : 0);
			lastRow.put(hasRight ? 1 : 0);
		}
		if(!firstLeafOnFirstRow && stats.height > leafHeight){
            lastRow.putFront(1);
		}
	} while(!queue.isEmpty());
	stats.height -= 1;
	stats.internalNodeCount = stats.nodeWithOneChildCount + stats.nodeWithTwoChildrenCount;
	stats.leafNodeCount = stats.nodeCount - stats.internalNodeCount;
	if(stats.balanced){
		lastRow.put(-1);

		while(!lastRow.isEmpty()){
			if(lastRow.peek() == -1){
				lastRow.get();
				if(lastRow.isEmpty())
					break;
				lastRow.put(-1);
			}
			int left, right;
			left = lastRow.get();
			right = lastRow.get();
			if(std::abs(left-right) <= 1){
				lastRow.put(left+right);
			} else {
				stats.perfectlyBalanced = false;
				break;
			}
//			zkontrolovat vyvenost poslednho dku
		}
	} else {
		stats.perfectlyBalanced = false;
	}
	return stats;
}
#endif

BinaryTree::Statistics BinaryTree::getStatistics(NodeRef nodeRef){
	Statistics stats = {0, 0, 0, 0, 0, 0, true, true};
	Node* node = *((Node**)&nodeRef);
	if(node != nullptr){
		stats = getStatisticsRecursive(node);
		stats.internalNodeCount = stats.nodeWithOneChildCount + stats.nodeWithTwoChildrenCount;
		stats.leafNodeCount = stats.nodeCount - stats.internalNodeCount;
		if(stats.height > 0)
			stats.height--;
	}
	return stats;
}
