/***************************************************************
 * Name:      binarySearchTreeMain.cpp
 * Purpose:   Code for Application Frame
 * Author:    Lukáš Kotržena (lkotrzena@gmail.com)
 * Created:   2016-04-28
 * Copyright: Lukáš Kotržena (http://www.kotrzena.eu)
 * License:
 **************************************************************/

#include "binarySearchTreeMain.h"
#include <wx/msgdlg.h>

// Unicode fix
#define _(s) wxGetTranslation((wxS(s)))

//(*InternalHeaders(binarySearchTreeFrame)
#include <wx/bitmap.h>
#include <wx/icon.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
//*)

//helper functions
enum wxbuildinfoformat {
    short_f, long_f };

wxString wxbuildinfo(wxbuildinfoformat format)
{
    wxString wxbuild(wxVERSION_STRING);

    if (format == long_f )
    {
#if defined(__WXMSW__)
        wxbuild << _T("-Windows");
#elif defined(__UNIX__)
        wxbuild << _T("-Linux");
#endif

#if wxUSE_UNICODE
        wxbuild << _T("-Unicode build");
#else
        wxbuild << _T("-ANSI build");
#endif // wxUSE_UNICODE
    }

    return wxbuild;
}

//(*IdInit(binarySearchTreeFrame)
const long binarySearchTreeFrame::ID_STATICBITMAP1 = wxNewId();
const long binarySearchTreeFrame::ID_SCROLLEDWINDOW1 = wxNewId();
const long binarySearchTreeFrame::ID_LISTVIEW1 = wxNewId();
const long binarySearchTreeFrame::ID_SPLITTERWINDOW1 = wxNewId();
const long binarySearchTreeFrame::idMenuNew = wxNewId();
const long binarySearchTreeFrame::idMenuOpen = wxNewId();
const long binarySearchTreeFrame::idMenuSave = wxNewId();
const long binarySearchTreeFrame::idMenuSaveAs = wxNewId();
const long binarySearchTreeFrame::idMenuExportToImage = wxNewId();
const long binarySearchTreeFrame::idMenuQuit = wxNewId();
const long binarySearchTreeFrame::idMenuShowValues = wxNewId();
const long binarySearchTreeFrame::idMenuDimensions = wxNewId();
const long binarySearchTreeFrame::ID_MENUITEM1 = wxNewId();
const long binarySearchTreeFrame::ID_MENUITEM2 = wxNewId();
const long binarySearchTreeFrame::idMenuAbout = wxNewId();
const long binarySearchTreeFrame::ID_STATUSBAR1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(binarySearchTreeFrame,wxFrame)
    //(*EventTable(binarySearchTreeFrame)
    //*)
END_EVENT_TABLE()

binarySearchTreeFrame::binarySearchTreeFrame(wxWindow* parent,wxWindowID id){
    //(*Initialize(binarySearchTreeFrame)
    wxMenuItem* MenuItem2;
    wxBoxSizer* BoxSizer2;
    wxMenu* Menu1;
    wxMenuItem* MenuFileQuit;
    wxBoxSizer* BoxSizer1;
    wxMenuBar* MenuBar1;
    wxMenu* Menu2;

    Create(parent, wxID_ANY, _("Statistiky binárního vyhledávacího stromu"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_FRAME_STYLE, _T("wxID_ANY"));
    SetClientSize(wxSize(600,400));
    {
    wxIcon FrameIcon;
    FrameIcon.CopyFromBitmap(wxICON(aaaa));
    SetIcon(FrameIcon);
    }
    BoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
    SplitterWindow1 = new wxSplitterWindow(this, ID_SPLITTERWINDOW1, wxDefaultPosition, wxDefaultSize, 0, _T("ID_SPLITTERWINDOW1"));
    SplitterWindow1->SetMinSize(wxSize(1,1));
    SplitterWindow1->SetMinimumPaneSize(1);
    SplitterWindow1->SetSashGravity(1);
    ScrolledWindow1 = new wxScrolledWindow(SplitterWindow1, ID_SCROLLEDWINDOW1, wxDefaultPosition, wxDefaultSize, wxVSCROLL|wxHSCROLL, _T("ID_SCROLLEDWINDOW1"));
    BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
    StaticBitmap1 = new wxStaticBitmap(ScrolledWindow1, ID_STATICBITMAP1, wxNullBitmap, wxDefaultPosition, wxDefaultSize, wxSUNKEN_BORDER, _T("ID_STATICBITMAP1"));
    BoxSizer1->Add(StaticBitmap1, 1, wxALL|wxEXPAND, 0);
    ScrolledWindow1->SetSizer(BoxSizer1);
    BoxSizer1->Fit(ScrolledWindow1);
    BoxSizer1->SetSizeHints(ScrolledWindow1);
    ListView1 = new wxListView(SplitterWindow1, ID_LISTVIEW1, wxDefaultPosition, wxDefaultSize, wxLC_REPORT|wxLC_NO_HEADER|wxSUNKEN_BORDER, wxDefaultValidator, _T("ID_LISTVIEW1"));
    SplitterWindow1->SplitVertically(ScrolledWindow1, ListView1);
    SplitterWindow1->SetSashPosition(430);
    BoxSizer2->Add(SplitterWindow1, 1, wxALL|wxEXPAND, 0);
    SetSizer(BoxSizer2);
    MenuBar1 = new wxMenuBar();
    Menu1 = new wxMenu();
    MenuFileNew = new wxMenuItem(Menu1, idMenuNew, _("Nový\tCtrl+N"), wxEmptyString, wxITEM_NORMAL);
    Menu1->Append(MenuFileNew);
    MenuFileOpen = new wxMenuItem(Menu1, idMenuOpen, _("Otevřít\tCtrl+O"), wxEmptyString, wxITEM_NORMAL);
    Menu1->Append(MenuFileOpen);
    MenuFileSave = new wxMenuItem(Menu1, idMenuSave, _("Uložit\tCtrl+S"), wxEmptyString, wxITEM_NORMAL);
    Menu1->Append(MenuFileSave);
    MenuFileSaveAs = new wxMenuItem(Menu1, idMenuSaveAs, _("Uložit jako\tCtrl+Alt+S"), wxEmptyString, wxITEM_NORMAL);
    Menu1->Append(MenuFileSaveAs);
    MenuFileExportToImage = new wxMenuItem(Menu1, idMenuExportToImage, _("Exportovat do obrázku"), wxEmptyString, wxITEM_NORMAL);
    Menu1->Append(MenuFileExportToImage);
    Menu1->AppendSeparator();
    MenuFileQuit = new wxMenuItem(Menu1, idMenuQuit, _("Ukončit\tAlt-F4"), wxEmptyString, wxITEM_NORMAL);
    Menu1->Append(MenuFileQuit);
    MenuBar1->Append(Menu1, _("&Soubor"));
    Menu3 = new wxMenu();
    MenuItem9 = new wxMenuItem(Menu3, idMenuShowValues, _("Zobrazit hodnoty"), wxEmptyString, wxITEM_CHECK);
    Menu3->Append(MenuItem9);
    MenuItem9->Check(true);
    MenuItem10 = new wxMenuItem(Menu3, idMenuDimensions, _("Nastavení vykreslování"), wxEmptyString, wxITEM_NORMAL);
    Menu3->Append(MenuItem10);
    MenuBar1->Append(Menu3, _("Zobrazit"));
    Menu4 = new wxMenu();
    MenuItem1 = new wxMenuItem(Menu4, ID_MENUITEM1, _("Přidat uzel\tCtrl+A"), wxEmptyString, wxITEM_NORMAL);
    Menu4->Append(MenuItem1);
    MenuItem3 = new wxMenuItem(Menu4, ID_MENUITEM2, _("Odstranit uzel\tCtrl+X"), wxEmptyString, wxITEM_NORMAL);
    Menu4->Append(MenuItem3);
    MenuBar1->Append(Menu4, _("Binární strom"));
    Menu2 = new wxMenu();
    MenuItem2 = new wxMenuItem(Menu2, idMenuAbout, _("O programu\tF1"), wxEmptyString, wxITEM_NORMAL);
    Menu2->Append(MenuItem2);
    MenuBar1->Append(Menu2, _("Nápověda"));
    SetMenuBar(MenuBar1);
    StatusBar1 = new wxStatusBar(this, ID_STATUSBAR1, 0, _T("ID_STATUSBAR1"));
    int __wxStatusBarWidths_1[3] = { -1, 100, 100 };
    int __wxStatusBarStyles_1[3] = { wxSB_NORMAL, wxSB_NORMAL, wxSB_NORMAL };
    StatusBar1->SetFieldsCount(3,__wxStatusBarWidths_1);
    StatusBar1->SetStatusStyles(3,__wxStatusBarStyles_1);
    SetStatusBar(StatusBar1);
    FileDialog1 = new wxFileDialog(this, _("Uložit jako"), wxEmptyString, wxEmptyString, _("*.txt"), wxFD_SAVE|wxFD_OVERWRITE_PROMPT, wxDefaultPosition, wxDefaultSize, _T("wxFileDialog"));
    FileDialog2 = new wxFileDialog(this, _("Otevřít"), wxEmptyString, wxEmptyString, _("*.txt"), wxFD_OPEN, wxDefaultPosition, wxDefaultSize, _T("wxFileDialog"));
    FileDialog3 = new wxFileDialog(this, _("Exportovat do obrázku"), wxEmptyString, wxEmptyString, _("PNG (*.png)|*.png|JPEG (*.jpg;*.jpeg)|*.jpg;*.jpeg|BMP (*.bmp)|*.bmp"), wxFD_SAVE|wxFD_OVERWRITE_PROMPT, wxDefaultPosition, wxDefaultSize, _T("wxFileDialog"));
    SetSizer(BoxSizer2);
    Layout();

    Connect(idMenuNew,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&binarySearchTreeFrame::OnMenuNew);
    Connect(idMenuOpen,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&binarySearchTreeFrame::OnMenuOpen);
    Connect(idMenuSave,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&binarySearchTreeFrame::onMenuSave);
    Connect(idMenuSaveAs,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&binarySearchTreeFrame::OnMenuSaveAs);
    Connect(idMenuExportToImage,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&binarySearchTreeFrame::OnMenuExportToImage);
    Connect(idMenuQuit,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&binarySearchTreeFrame::OnQuit);
    Connect(idMenuShowValues,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&binarySearchTreeFrame::OnShowValues);
    Connect(idMenuDimensions,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&binarySearchTreeFrame::OnMenuDimensions);
    Connect(ID_MENUITEM1,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&binarySearchTreeFrame::OnMenuAddNode);
    Connect(ID_MENUITEM2,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&binarySearchTreeFrame::OnMenuRemoveNode);
    Connect(idMenuAbout,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&binarySearchTreeFrame::OnAbout);
    //*)
    boxSizer = BoxSizer1;

    /*tree.insertValue(5);
    tree.insertValue(3);
    tree.insertValue(10);
    tree.insertValue(1);
    tree.insertValue(7);
    tree.insertValue(12);*/


    /*tree.insertValue(13);
    tree.insertValue(14);
    tree.insertValue(15);
    tree.insertValue(16);
    tree.insertValue(17);
    tree.insertValue(18);
    tree.insertValue(19);
    tree.insertValue(20);*/
    ListView1->InsertColumn(0, wxEmptyString);
    ListView1->InsertColumn(1, wxEmptyString, wxLIST_FORMAT_RIGHT);
    ListView1->SetColumnWidth(0, 120);
    ListView1->SetColumnWidth(1, 40);

    ListView1->InsertItem(0, _("Výška"));
    ListView1->InsertItem(1, _("Uzlů"));
    ListView1->InsertItem(2, _("Vnitřních uzlů"));
    ListView1->InsertItem(3, _("Listů"));
    ListView1->InsertItem(4, _("Uzlů s jedním potomkem"));
    ListView1->InsertItem(5, _("Uzlů s dvěma potomky"));
    ListView1->InsertItem(6, _("Vyvážený"));
    ListView1->InsertItem(7, _("Dokonale vyvážený"));

    ScrolledWindow1->SetScrollRate(1, 1);

    /*bitmap.Create(500,500);
    //Panel1->
    ScrolledWindow1->SetScrollRate(10,10);

    wxMemoryDC dc(bitmap);
    dc.DrawCircle(500,500,500);
    StaticBitmap1->SetBitmap(bitmap);*/
    //drawTree();
    int widths[] = {-1, 150, 150};
    StatusBar1->SetFieldsCount(3, widths);
    //StatusBar1->SetLabel("Neco");
    //StatusBar1->SetStatusText("lorem", 0);
    //StatusBar1->SetStatusText("ipsum", 1);
    //StatusBar1->SetStatusText("dolor", 2);

    nodeWidth = 30;
	spaceBetweenNodes = 10;
	startFromRoot = true;
	maxHeight = -1;
	showValues = true;
}

binarySearchTreeFrame::~binarySearchTreeFrame(){
    //(*Destroy(binarySearchTreeFrame)
    //*)
}

void binarySearchTreeFrame::OnQuit(wxCommandEvent& event){
    Close();
}

void binarySearchTreeFrame::OnAbout(wxCommandEvent& event){
    wxString msg = _("Vytvořil:\nLukáš Kotržena\nlkotrzena@gmail.com\nhttp://www.kotrzena.eu/\n") + wxbuildinfo(long_f);
    wxMessageBox(msg, _("Statistiky binárního vyhledávacího stromu"));
}

void binarySearchTreeFrame::OnButton1Click(wxCommandEvent& event){
    //wxBitmap bitmap(500, 500);
    wxMemoryDC dc(bitmap);
    dc.DrawCircle(500,500,50);
    StaticBitmap1->SetBitmap(bitmap);
    boxSizer->RecalcSizes();
    //Refresh();
    //Update();
    //ScrolledWindow1->Refresh();
    //wxSize size(500,500);
    //ScrolledWindow1->SetVirtualSize(size);
}

unsigned int binarySearchTreeFrame::drawSubTree(wxMemoryDC &dc, BinaryTree::NodeRef node, unsigned int level, unsigned int offset, bool isLeft){
	if(!node.isValid() || level > maxHeight)
		return nodeWidth/2 + ((offset == 0)? 0 : spaceBetweenNodes/2);
	/*if(!node.getLeft().isValid() && !node.getLeft().isValid()){
		int y = (nodeWidth/2)+(level-1)*(nodeWidth + spaceBetweenNodes);
		drawNode(node, offset, y);
		return nodeWidth;
	}*/
	unsigned int leftWidth = drawSubTree(dc, node.getLeft(), level+1, offset, true);
	unsigned int rightWidth = drawSubTree(dc, node.getRight(), level+1, offset+leftWidth, false);
	int x = offset + leftWidth;
	int y = (nodeWidth/2)+(level)*(nodeWidth + spaceBetweenNodes);

	dc.DrawLine(x, y, (isLeft? offset + leftWidth + rightWidth : offset), (nodeWidth/2)+(level-1)*(nodeWidth + spaceBetweenNodes));
	dc.DrawCircle(x, y, (nodeWidth/2));
	if(showValues)
		dc.DrawLabel(wxString::Format(wxT("%i"), node.getValue()), wxRect(x, y, 0, 0), wxALIGN_CENTER);

	return leftWidth + rightWidth;
}

void binarySearchTreeFrame::drawTree(){
	StatusBar1->SetStatusText(_("Probíhá vykreslování..."), 0);
	wxStopWatch sw;

	BinaryTree::NodeRef startNode = tree.getRoot();
	unsigned int startNodeHeight = 0;

	unsigned int width = treeStats.leafNodeCount*(nodeWidth+spaceBetweenNodes) + treeStats.nodeWithOneChildCount*(nodeWidth/2 + spaceBetweenNodes/2) - spaceBetweenNodes + 1;
	unsigned int height = (((treeStats.height - startNodeHeight -1 < maxHeight)? treeStats.height - startNodeHeight : maxHeight+1)+1)*nodeWidth + ((treeStats.height - startNodeHeight < maxHeight)? treeStats.height - startNodeHeight : maxHeight)*spaceBetweenNodes + 1;

	if(!startFromRoot){
		while( startNode.isValid() && startNode.getValue() != startValue){
			if(startValue < startNode.getValue())
				startNode.goLeft();
			else
				startNode.goRight();
			startNodeHeight++;
		}
	}
	if(startNode.isValid()){
		if(!startFromRoot || maxHeight < treeStats.height){
			BinaryTree::Statistics subTreeStats = tree.getStatistics(startNode);
			width = subTreeStats.leafNodeCount*(nodeWidth+spaceBetweenNodes) + subTreeStats.nodeWithOneChildCount*(nodeWidth/2 + spaceBetweenNodes/2) - spaceBetweenNodes + 1;
		} else
			width = treeStats.leafNodeCount*(nodeWidth+spaceBetweenNodes) + treeStats.nodeWithOneChildCount*(nodeWidth/2 + spaceBetweenNodes/2) - spaceBetweenNodes + 1;

		bitmap.Create(width, height);
	} else {
		bitmap.Create(0, 0);
	}
    if(bitmap.IsOk()){
		wxMemoryDC* dc = new wxMemoryDC(bitmap);

		dc->SetPen(wxPen(ScrolledWindow1->GetBackgroundColour()));
        dc->SetBrush(wxBrush(ScrolledWindow1->GetBackgroundColour()));
        dc->DrawRectangle(0, 0, width, height);

        dc->SetPen(*wxBLACK_PEN);
        dc->SetBrush(*wxWHITE_BRUSH);
		if(startNode.isValid()){
			unsigned int leftWidth = drawSubTree(*dc, startNode.getLeft(), 1, 0, true);
			unsigned int rightWidth = drawSubTree(*dc, startNode.getRight(), 1, leftWidth, false);
			dc->DrawCircle(leftWidth, (nodeWidth/2), (nodeWidth/2));
			if(showValues)
				dc->DrawLabel(wxString::Format(wxT("%i"), startNode.getValue()), wxRect(leftWidth, (nodeWidth/2), 0, 0), wxALIGN_CENTER);
			//bitmap.SetSize(leftWidth + rightWidth, height);
			delete dc;
			if(leftWidth + rightWidth < width){
				wxBitmap subBitmap = bitmap.GetSubBitmap(wxRect(0, 0, leftWidth + rightWidth, height));
				subBitmap.SaveFile("wtf.png", wxBITMAP_TYPE_PNG);
				bitmap = subBitmap;
			}
			//bitmap.SetWidth(leftWidth + rightWidth);
		}
		//drawSubTree(dc, startNode, 0, 0, false);
    } else {
		wxMemoryDC dc(bitmap);
		wxSize size = dc.GetTextExtent(_("Strom nelze vykreslit!"));
		bitmap.Create(size);
		dc.SelectObject(bitmap);
		dc.SetPen(*wxRED_PEN);
		dc.SetBrush(*wxRED_BRUSH);
		dc.DrawRectangle(wxPoint(0, 0), size);
		dc.SetTextForeground(*wxWHITE);
		dc.DrawText(_("Strom nelze vykreslit!"), 0, 0);
	}

	/*

    unsigned int lastRowNodeCount = pow(2, (treeStats.height - startNodeHeight < maxHeight)? treeStats.height - startNodeHeight : maxHeight);
    unsigned int width = lastRowNodeCount*nodeWidth+(lastRowNodeCount-1)*spaceBetweenNodes;
    unsigned int height = (((treeStats.height - startNodeHeight -1 < maxHeight)? treeStats.height - startNodeHeight : maxHeight+1)+1)*nodeWidth + ((treeStats.height - startNodeHeight < maxHeight)? treeStats.height - startNodeHeight : maxHeight)*spaceBetweenNodes+1;

    bitmap.Create(width, height);
    if(bitmap.IsOk()){
        wxMemoryDC dc(bitmap);

        dc.SetPen(wxPen(ScrolledWindow1->GetBackgroundColour()));
        dc.SetBrush(wxBrush(ScrolledWindow1->GetBackgroundColour()));
        dc.DrawRectangle(0, 0, width, height);

        dc.SetPen(*wxBLACK_PEN);
        dc.SetBrush(*wxWHITE_BRUSH);

        unsigned int level = 1;
        unsigned int fromLeft = 1;
        Queue<BinaryTree::NodeRef> queue;
        queue.put(startNode);
        do {
            BinaryTree::NodeRef node = queue.get();
			if(level-1 < maxHeight){
				queue.put(node.getLeft());
				queue.put(node.getRight());
			}
            if(node.isValid()){
                int x = (pow(0.5, level) + (fromLeft-1)*pow(0.5, level-1))*width;
                int y = (nodeWidth/2)+(level-1)*(nodeWidth + spaceBetweenNodes);

                if(node.getLeft().isValid()){
                    int x2 = (pow(0.5, level+1) + ( (fromLeft-1)*2 )*pow(0.5, level))*width;
                    int y2 = (nodeWidth/2)+(level)*(nodeWidth + spaceBetweenNodes);
                    dc.DrawLine(x, y, x2, y2);
                }
                if(node.getRight().isValid()){
                    int x2 = (pow(0.5, level+1) + ( (fromLeft-1)*2+1 )*pow(0.5, level))*width;
                    int y2 = (nodeWidth/2)+(level)*(nodeWidth + spaceBetweenNodes);
                    dc.DrawLine(x, y, x2, y2);
                }

                dc.DrawCircle(x, y, (nodeWidth/2));
                if(showValues)
					dc.DrawLabel(wxString::Format(wxT("%i"), node.getValue()), wxRect(x, y, 0, 0), wxALIGN_CENTER);
            }
            fromLeft++;
            if(fromLeft > pow(2, level-1)){
                fromLeft = 1;
                level++;
            }
        } while(!queue.isEmpty() && level-1 <= (treeStats.height - startNodeHeight));
        //dc.DrawCircle(1,25,25);
        //bitmap.SaveFile("strom.png", wxBITMAP_TYPE_PNG);
    } else {
        wxMemoryDC dc(bitmap);
        wxSize size = dc.GetTextExtent(_("Strom nelze vykreslit!"));
        bitmap.Create(size);
        dc.SelectObject(bitmap);
        dc.SetPen(*wxRED_PEN);
        dc.SetBrush(*wxRED_BRUSH);
        dc.DrawRectangle(wxPoint(0, 0), size);
        dc.SetTextForeground(*wxWHITE);
        dc.DrawText(_("Strom nelze vykreslit!"), 0, 0);
    }*/
    StaticBitmap1->SetBitmap(bitmap);
    //boxSizer->RecalcSizes();
    //ScrolledWindow1->SetVirtualSize(boxSizer->GetSize());

    //boxSizer->RecalcSizes();
    //boxSizer2->RecalcSizes();
    //SplitterWindow1->UpdateSize();
    //Update();
    wxSizeEvent sizeEvent(GetSize());
    ScrolledWindow1->HandleOnSize(sizeEvent);
    //SetSize(GetSize().GetX()+1, GetSize().GetY());
	sw.Pause();
    StatusBar1->SetStatusText(wxString::Format(wxT("%s: %s μs"), _("Vykreslení"), sw.TimeInMicro().ToString()), 2);
    if(!startFromRoot && (int)maxHeight != -1)
		StatusBar1->SetStatusText(wxString::Format(_("Zobrazeno od uzlu s hodnotou %i a maximální výškou %i"), startValue, maxHeight), 0);
	else if(!startFromRoot)
		StatusBar1->SetStatusText(wxString::Format(_("Zobrazeno od uzlu s hodnotou %i"), startValue), 0);
	else if((int)maxHeight != -1)
		StatusBar1->SetStatusText(wxString::Format(_("Zobrazeno s maximální výškou %i"), maxHeight), 0);
	else
		StatusBar1->SetStatusText(wxEmptyString, 0);
}

void binarySearchTreeFrame::openTree(){
    tree.removeAll();
    std::ifstream file(treeFilePath.ToStdString());
    if(file.is_open()){
		while(true){
			int value;
			file >> value;
			if(file.bad() || file.fail())
				break;
			tree.insertValue(value);
		}
		file.close();
		updateTreeStatistics();
		drawTree();
	} else {
		wxMessageBox(_("Soubor se nepodařilo otevřít."), _("Chyba"), wxICON_ERROR);
	}
}

void binarySearchTreeFrame::updateTreeStatistics(){
	{
		StatusBar1->SetStatusText(_("Výpočet statistik..."), 0);
		wxStopWatch sw;
		treeStats = tree.getStatistics();
		sw.Pause();
		StatusBar1->SetStatusText(wxString::Format(wxT("%s: %s μs"), _("Výpočet"), sw.TimeInMicro().ToString()), 1);
	}
	StatusBar1->SetStatusText(wxEmptyString, 0);
	/*
		unsigned int height;
		unsigned int nodeCount;
		unsigned int internalNodeCount;
		unsigned int leafNodeCount;
		unsigned int nodeWithOneChildCount;
		unsigned int nodeWithTwoChildrenCount;
		bool balanced;
		bool perfectlyBalanced;
    */
    ListView1->SetItem(0, 1, wxString::Format("%i", treeStats.height));
    ListView1->SetItem(1, 1, wxString::Format("%i", treeStats.nodeCount));
    ListView1->SetItem(2, 1, wxString::Format("%i", treeStats.internalNodeCount));
    ListView1->SetItem(3, 1, wxString::Format("%i", treeStats.leafNodeCount));
    ListView1->SetItem(4, 1, wxString::Format("%i", treeStats.nodeWithOneChildCount));
    ListView1->SetItem(5, 1, wxString::Format("%i", treeStats.nodeWithTwoChildrenCount));
    ListView1->SetItem(6, 1, treeStats.balanced ? _("Ano") : _("Ne"));
    ListView1->SetItem(7, 1, treeStats.perfectlyBalanced ? _("Ano") : _("Ne"));
}

void binarySearchTreeFrame::OnMenuSaveAs(wxCommandEvent& event){
    if(FileDialog1->ShowModal() == wxID_OK){
        treeFilePath = FileDialog1->GetPath();
        onMenuSave(event);
    }
}

void binarySearchTreeFrame::onMenuSave(wxCommandEvent& event){
	if(treeFilePath.IsEmpty()){
		OnMenuSaveAs(event);
		return;
	}
    Queue<BinaryTree::NodeRef> queue;
    queue.put(tree.getRoot());
    std::ofstream file(treeFilePath.ToStdString());
    if(file.is_open()){
		do {
			BinaryTree::NodeRef node = queue.get();
			if(node.isValid()){
				queue.put(node.getLeft());
				queue.put(node.getRight());
				file << node.getValue() << '\n';
			}
		} while(!queue.isEmpty());
		file.close();
    } else {
		wxMessageBox(_("Soubor se nepodařilo otevřít."), _("Chyba"), wxICON_ERROR);
    }
}

void binarySearchTreeFrame::OnMenuOpen(wxCommandEvent& event){
	if(FileDialog2->ShowModal() == wxID_OK){
		treeFilePath = FileDialog2->GetPath();
		openTree();
	}
}

void binarySearchTreeFrame::OnMenuDimensions(wxCommandEvent& event){
	DimensionsDialog dialog(this);
	dialog.TextCtrl1->SetValue(wxString::Format("%i", nodeWidth));
	dialog.TextCtrl2->SetValue(wxString::Format("%i", spaceBetweenNodes));
	dialog.CheckBox1->SetValue(startFromRoot);
	dialog.TextCtrl3->Enable(!dialog.CheckBox1->IsChecked());
	dialog.TextCtrl3->SetValue(wxString::Format("%i", startValue));
	dialog.TextCtrl4->SetValue(wxString::Format("%i", maxHeight));
	if(dialog.ShowModal() == wxID_OK){
		{
			unsigned long x;
			if(dialog.TextCtrl1->GetValue().ToULong(&x))
				nodeWidth = (unsigned int)x;
			if(dialog.TextCtrl2->GetValue().ToULong(&x))
				spaceBetweenNodes = (unsigned int)x;
		}
		startFromRoot = dialog.CheckBox1->IsChecked();
		long x;
		if(dialog.TextCtrl3->GetValue().ToLong(&x))
			startValue = (int)x;
		if(dialog.TextCtrl4->GetValue().ToLong(&x))
			maxHeight = (unsigned int)x;

		drawTree();
	}
}

void binarySearchTreeFrame::OnShowValues(wxCommandEvent& event){
	showValues = event.IsChecked();
	drawTree();
}

void binarySearchTreeFrame::OnMenuExportToImage(wxCommandEvent& event){
	if(FileDialog3->ShowModal() == wxID_OK){
		wxString filePath = FileDialog3->GetPath();
		switch(FileDialog3->GetFilterIndex()){
			case 0:
				bitmap.SaveFile(filePath, wxBITMAP_TYPE_PNG);
				break;
			case 1:
				bitmap.SaveFile(filePath, wxBITMAP_TYPE_JPEG);
				break;
			case 2:
				bitmap.SaveFile(filePath, wxBITMAP_TYPE_BMP);
				break;
		}
    }
}

void binarySearchTreeFrame::OnMenuAddNode(wxCommandEvent& event){
	wxTextEntryDialog dialog(this, _("Zadejte hodnotu uzlu:"), _("Přidat uzel"));
	dialog.SetTextValidator(wxFILTER_NUMERIC);
	if(dialog.ShowModal() == wxID_OK){
		long value;
		dialog.GetValue().ToLong(&value);
		tree.insertValue((int)value);
	}
	updateTreeStatistics();
	drawTree();
}

void binarySearchTreeFrame::OnMenuRemoveNode(wxCommandEvent& event){
	wxTextEntryDialog dialog(this, _("Zadejte hodnotu uzlu:"), _("Odstranit uzel"));
	dialog.SetTextValidator(wxFILTER_NUMERIC);
	if(dialog.ShowModal() == wxID_OK){
		long value;
		dialog.GetValue().ToLong(&value);
		tree.removeValue((int)value);
	}
	updateTreeStatistics();
	drawTree();
}

void binarySearchTreeFrame::OnMenuNew(wxCommandEvent& event){
	tree.removeAll();
	StaticBitmap1->SetBitmap(wxBitmap());
	drawTree();
	updateTreeStatistics();
}
