/***************************************************************
 * Name:      binarySearchTreeMain.h
 * Purpose:   Defines Application Frame
 * Author:    Lukáš Kotržena (lkotrzena@gmail.com)
 * Created:   2016-04-28
 * Copyright: Lukáš Kotržena (http://www.kotrzena.eu)
 * License:
 **************************************************************/

#ifndef BINARYSEARCHTREEMAIN_H
#define BINARYSEARCHTREEMAIN_H

//(*Headers(binarySearchTreeFrame)
#include <wx/listctrl.h>
#include <wx/scrolwin.h>
#include <wx/sizer.h>
#include <wx/menu.h>
#include <wx/splitter.h>
#include <wx/filedlg.h>
#include <wx/statbmp.h>
#include <wx/frame.h>
#include <wx/statusbr.h>
//*)
#include <wx/generic/statbmpg.h>
#include <wx/dcclient.h>
#include <wx/dcmemory.h>
#include <wx/file.h>
#include <cmath>
#include "queue.h"
#include "binarytree.h"
#include <fstream>
#include <wx/stopwatch.h>
#include <wx/textdlg.h>
#include "DimensionsDialog.h"

class binarySearchTreeFrame: public wxFrame
{
    public:

        binarySearchTreeFrame(wxWindow* parent,wxWindowID id = -1);
        virtual ~binarySearchTreeFrame();

    private:

        //(*Handlers(binarySearchTreeFrame)
        void OnQuit(wxCommandEvent& event);
        void OnAbout(wxCommandEvent& event);
        void OnButton1Click(wxCommandEvent& event);
        void OnMenuSaveAs(wxCommandEvent& event);
        void onMenuSave(wxCommandEvent& event);
        void OnMenuOpen(wxCommandEvent& event);
        void OnMenuDimensions(wxCommandEvent& event);
        void OnShowValues(wxCommandEvent& event);
        void OnMenuExportToImage(wxCommandEvent& event);
        void OnMenuAddNode(wxCommandEvent& event);
        void OnMenuRemoveNode(wxCommandEvent& event);
        void OnMenuNew(wxCommandEvent& event);
        //*)

        //(*Identifiers(binarySearchTreeFrame)
        static const long ID_STATICBITMAP1;
        static const long ID_SCROLLEDWINDOW1;
        static const long ID_LISTVIEW1;
        static const long ID_SPLITTERWINDOW1;
        static const long idMenuNew;
        static const long idMenuOpen;
        static const long idMenuSave;
        static const long idMenuSaveAs;
        static const long idMenuExportToImage;
        static const long idMenuQuit;
        static const long idMenuShowValues;
        static const long idMenuDimensions;
        static const long ID_MENUITEM1;
        static const long ID_MENUITEM2;
        static const long idMenuAbout;
        static const long ID_STATUSBAR1;
        //*)

        //(*Declarations(binarySearchTreeFrame)
        wxFileDialog* FileDialog3;
        wxMenuItem* MenuFileSaveAs;
        wxMenuItem* MenuFileExportToImage;
        wxScrolledWindow* ScrolledWindow1;
        wxMenu* Menu3;
        wxStaticBitmap* StaticBitmap1;
        wxMenuItem* MenuItem1;
        wxMenuItem* MenuFileOpen;
        wxMenuItem* MenuFileNew;
        wxFileDialog* FileDialog1;
        wxMenuItem* MenuItem10;
        wxMenuItem* MenuItem3;
        wxStatusBar* StatusBar1;
        wxListView* ListView1;
        wxFileDialog* FileDialog2;
        wxMenuItem* MenuFileSave;
        wxSplitterWindow* SplitterWindow1;
        wxMenuItem* MenuItem9;
        wxMenu* Menu4;
        //*)

        DECLARE_EVENT_TABLE()

        BinaryTree tree;
        BinaryTree::Statistics treeStats;

        unsigned int nodeWidth;
		unsigned int spaceBetweenNodes;
		bool startFromRoot;
		int startValue;
		unsigned int maxHeight;
		bool showValues;

        unsigned int drawSubTree(wxMemoryDC &dc, BinaryTree::NodeRef node, unsigned int level, unsigned int offset, bool isLeft);
        void drawTree();
        void openTree();
        void updateTreeStatistics();

        wxString treeFilePath;
        wxBitmap bitmap;
        wxBoxSizer *boxSizer;
};

#endif // BINARYSEARCHTREEMAIN_H
